# Funkce pro kontrolu vanocniho obarveni.
#
# Argument tree oznacuje vrchol stromu.
#
# Kazdy vrchol ma 3 atributy: barvu, levy podstrom a pravy podstrom,
# pristupujete k nim nasledovne: node.color, node.left, node.right.
# Pokud je nektery podstrom prazdny, je hodnota prislusneho atributu None,
# napr. pro listove uzly plati: node.left is None and node.right is None
# Barva uzlu (node.color) je retezec ("Blue", "Red" nebo "Green"). Pro priklad
# stromu se podivejte do run2_3.py. Muzete si vytvorit dalsi stromy pro
# testovani funkce is_christmas_tree, ale nezasahujte do definice tridy Node.
#
# Funkce vraci True, pokud je strom korektne obarveny, jinak False
#
# Strom je korektne obarveny, pokud zadne 2 sousedni vrcholy
# (mysleno vrchol a jeho potomek) nemaji stejnou barvu
# a soucasne kazdi 2 potomci tehoz vrcholu jsou taktez ruznobarevni.
def is_christmas_tree(node):
    # ================= zde implementujte telo funkce =====================
    if (node.left != None) and ((node.left.color == node.color) or (not is_christmas_tree(node.left))): return False

    if node.right != None:
        if (node.right.color == node.color) or (not is_christmas_tree(node.right)): return False
        if (node.left != None) and (node.right.color == node.left.color): return False

    return True
    # =====================================================================
